/**
 * This module updates the UI during an asynchronous
 * backup or restore process.
 *
 * @module     core_backup/async_backup
 * @copyright  2018 Matt Porritt <mattp@catalyst-au.net>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 * @since      3.7
 */
define("core_backup/async_backup",["jquery","core/ajax","core/str","core/notification","core/templates"],(function($,ajax,Str,notification,Templates){var backupid,contextid,restoreurl,typeid,backupintervalid,allbackupintervalid,allcopyintervalid,Asyncbackup={},checkdelay=15e3;function updateElement(backupid,type,percentage){var percentagewidth=Math.round(percentage)+"%",elementbar=document.querySelectorAll("[data-"+type+"id="+CSS.escape(backupid)+"]")[0],percentagetext=percentage.toFixed(2)+"%";elementbar.setAttribute("aria-valuenow",percentagewidth),elementbar.style.width=percentagewidth,elementbar.innerHTML=percentagetext}function updateInterval(intervalid,callback,value){return clearInterval(intervalid),setInterval(callback,value)}function updateProgressAll(progress){progress.forEach((function(element){var percentage=100*element.progress,backupid=element.backupid,type=element.operation,elementbar=document.querySelectorAll("[data-"+type+"id="+CSS.escape(backupid)+"]")[0];800==element.status?(elementbar.classList.add("bg-success"),updateElement(backupid,type,percentage)):900==element.status?(elementbar.classList.add("bg-danger"),elementbar.classList.add("complete"),elementbar.classList.remove("bg-success"),updateElement(backupid,type,100)):1e3==element.status&&(elementbar.classList.add("bg-success"),elementbar.classList.add("complete"),updateElement(backupid,type,100),"backup"==type?function(backupid){var statuscell=$("#"+backupid+"_bar").parent().parent(),tablerow=statuscell.parent(),cellsiblings=statuscell.siblings(),timecell=cellsiblings[1],timevalue=$(timecell).text(),filenamecell=cellsiblings[0],filename=$(filenamecell).text();ajax.call([{methodname:"core_backup_get_async_backup_links_backup",args:{filename:filename,contextid:contextid}}])[0].done((function(response){var context={filename:filename,time:timevalue,size:response.filesize,fileurl:response.fileurl,restoreurl:response.restoreurl};Templates.render("core/async_backup_progress_row",context).then((function(html,js){Templates.replaceNodeContents(tablerow,html,js)})).fail((function(){notification.exception(new Error("Failed to load table row"))}))}))}(backupid):function(backupid){var statuscell=$("#"+backupid+"_bar").parent().parent(),tablerow=statuscell.parent(),cellsiblings=statuscell.siblings(),coursecell=cellsiblings[0],timecell=cellsiblings[1],timevalue=$(timecell).text();ajax.call([{methodname:"core_backup_get_async_backup_links_restore",args:{backupid:backupid,contextid:contextid}}])[0].done((function(response){var context={resourcename:$(coursecell).text(),restoreurl:response.restoreurl,time:timevalue};Templates.render("core/async_restore_progress_row",context).then((function(html,js){Templates.replaceNodeContents(tablerow,html,js)})).fail((function(){notification.exception(new Error("Failed to load table row"))}))}))}(backupid))}))}function updateProgressCopy(progress){progress.forEach((function(element){var percentage=100*element.progress,backupid=element.backupid,type=element.operation,elementbar=document.querySelectorAll("[data-"+type+"id="+CSS.escape(backupid)+"]")[0];if("restore"==type){let restorecell=elementbar.closest("tr").children[3];Str.get_string("restore").then((function(content){restorecell.innerHTML=content})).catch((function(){notification.exception(new Error("Failed to load string: restore"))}))}800==element.status?(elementbar.classList.add("bg-success"),updateElement(backupid,type,percentage)):900==element.status?(elementbar.classList.add("bg-danger"),elementbar.classList.add("complete"),elementbar.classList.remove("bg-success"),updateElement(backupid,type,100)):1e3==element.status&&"restore"==type&&(elementbar.classList.add("bg-success"),elementbar.classList.add("complete"),updateElement(backupid,type,100),function(backupid){var elementbar=document.querySelectorAll("[data-restoreid="+CSS.escape(backupid)+"]")[0],restorecourse=elementbar.closest("tr").children[1],coursename=restorecourse.innerHTML,courselink=document.createElement("a"),elementbarparent=elementbar.closest("td"),operation=elementbarparent.previousElementSibling;Str.get_string("complete").then((function(content){operation.innerHTML=content})).catch((function(){notification.exception(new Error("Failed to load string: complete"))})),Templates.render("core/async_copy_complete_cell",{}).then((function(html,js){Templates.replaceNodeContents(elementbarparent,html,js)})).fail((function(){notification.exception(new Error("Failed to load table cell"))})),ajax.call([{methodname:"core_backup_get_async_backup_links_restore",args:{backupid:backupid,contextid:0}}])[0].done((function(response){courselink.setAttribute("href",response.restoreurl),courselink.innerHTML=coursename,restorecourse.innerHTML=null,restorecourse.appendChild(courselink)})).fail((function(){notification.exception(new Error("Failed to update table row"))}))}(backupid))}))}function getBackupProgress(){ajax.call([{methodname:"core_backup_get_async_backup_progress",args:{backupids:[backupid],contextid:contextid}}],!0,!0,!1,2e3)[0].done((function(response){!function(progress){var stringRequests,percentage=100*progress.progress,type="backup",elementbar=document.querySelectorAll("[data-backupid="+CSS.escape(backupid)+"]")[0],elementstatus=$("#"+backupid+"_status"),elementdetail=$("#"+backupid+"_detail"),elementbutton=$("#"+backupid+"_button");if(800==progress.status){elementbar.classList.add("bg-success"),updateElement(backupid,type,percentage);var strProcessing="async"+typeid+"processing";Str.get_string(strProcessing,"backup").then((function(title){elementstatus.text(title)})).catch((function(){notification.exception(new Error("Failed to load string: backup "+strProcessing))}))}else if(900==progress.status)elementbar.classList.add("bg-danger"),elementbar.classList.remove("bg-success"),updateElement(backupid,type,100),stringRequests=[{key:"async"+typeid+"error",component:"backup"},{key:"async"+typeid+"errordetail",component:"backup"}],Str.get_strings(stringRequests).then((function(strings){elementstatus.text(strings[0]),elementdetail.text(strings[1])})).catch((function(){notification.exception(new Error("Failed to load string"))})),$(".backup_progress").children("span").removeClass("backup_stage_current"),$(".backup_progress").children("span").last().addClass("backup_stage_current"),clearInterval(backupintervalid);else if(1e3==progress.status){elementbar.classList.add("bg-success"),updateElement(backupid,type,100);var strComplete="async"+typeid+"complete";Str.get_string(strComplete,"backup").then((function(title){elementstatus.text(title)})).catch((function(){notification.exception(new Error("Failed to load string: backup "+strComplete))})),"restore"==typeid?ajax.call([{methodname:"core_backup_get_async_backup_links_restore",args:{backupid:backupid,contextid:contextid}}])[0].done((function(response){var strButton="async"+typeid+"completebutton",stringRequests=[{key:"async"+typeid+"completedetail",component:"backup",param:response.restoreurl},{key:strButton,component:"backup"}];Str.get_strings(stringRequests).then((function(strings){elementdetail.html(strings[0]),elementbutton.text(strings[1]),elementbutton.attr("href",response.restoreurl)})).catch((function(){notification.exception(new Error("Failed to load string"))}))})):(stringRequests=[{key:"async"+typeid+"completedetail",component:"backup",param:restoreurl},{key:"async"+typeid+"completebutton",component:"backup"}],Str.get_strings(stringRequests).then((function(strings){elementdetail.html(strings[0]),elementbutton.text(strings[1]),elementbutton.attr("href",restoreurl)})).catch((function(){notification.exception(new Error("Failed to load string"))}))),$(".backup_progress").children("span").removeClass("backup_stage_current"),$(".backup_progress").children("span").last().addClass("backup_stage_current"),clearInterval(backupintervalid)}}(response[0]),checkdelay=15e3,backupintervalid=updateInterval(backupintervalid,getBackupProgress,15e3)})).fail((function(){backupintervalid=updateInterval(backupintervalid,getBackupProgress,checkdelay*=1.5)}))}function getAllBackupProgress(){var backupids=[];$(".progress").find(".progress-bar").not(".complete").each((function(){backupids.push(this.id.substring(0,32))})),backupids.length>0?ajax.call([{methodname:"core_backup_get_async_backup_progress",args:{backupids:backupids,contextid:contextid}}],!0,!0,!1,2e3)[0].done((function(response){updateProgressAll(response),checkdelay=15e3,allbackupintervalid=updateInterval(allbackupintervalid,getAllBackupProgress,15e3)})).fail((function(){allbackupintervalid=updateInterval(allbackupintervalid,getAllBackupProgress,checkdelay*=1.5)})):clearInterval(allbackupintervalid)}function getAllCopyProgress(){var copyids=[];$(".progress").find(".progress-bar[data-operation][data-backupid][data-restoreid]").not(".complete").each((function(){let progressvars={backupid:this.dataset.backupid,restoreid:this.dataset.restoreid,operation:this.dataset.operation};copyids.push(progressvars)})),copyids.length>0?ajax.call([{methodname:"core_backup_get_copy_progress",args:{copies:copyids}}],!0,!0,!1,2e3)[0].done((function(response){updateProgressCopy(response),checkdelay=15e3,allcopyintervalid=updateInterval(allcopyintervalid,getAllCopyProgress,15e3)})).fail((function(){allcopyintervalid=updateInterval(allcopyintervalid,getAllCopyProgress,checkdelay*=1.5)})):clearInterval(allcopyintervalid)}return Asyncbackup.asyncBackupAllStatus=function(context){contextid=context,allbackupintervalid=setInterval(getAllBackupProgress,checkdelay)},Asyncbackup.asyncCopyAllStatus=function(){allcopyintervalid=setInterval(getAllCopyProgress,checkdelay)},Asyncbackup.asyncBackupStatus=function(backup,context,restore,type){backupid=backup,contextid=context,restoreurl=restore,typeid="backup"==type?"backup":"restore",$(".backup_progress").children("a").removeAttr("href"),backupintervalid=setInterval(getBackupProgress,checkdelay)},Asyncbackup}));

//# sourceMappingURL=async_backup.min.js.map